---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.8 - Ontological States (index)

> Minimal state labels that summarize interface/graph conditions. Use as pointers into Relations, Patterns, and Diagnostics.

---

## States Framework

| State | Description | Key Test |
|----------|-------------|----------|
| [[Ontologically Connected]] | Interfaces open | Path check |
| [[Ontologically Disconnected]] | Interfaces closed | Block test |

Each state provides:
- Technical and humane test criteria
- Scale-dependent manifestations
- State transition patterns
- Stability conditions

---

## Core References

Primitives:
- [[Form]]
- [[Field]]
- [[Void]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

Related Patterns:
- [[20.0.1 - Form Classifications (index)]]
- [[20.0.2 - Field Classifications (index)]]
- [[20.0.3 - Awareness Classifications (index)]]
- [[20.0.4 - Propagation Patterns (index)]]
- [[20.0.5 - Interaction Dynamics (index)]]
- [[20.0.6 - Stability Diagnostics (index)]]
- [[20.0.7 - Structural Relations (index)]]